/* FILE: mreboot.h                              (D. Tottingham  12/26/90)

This is an include file of the defines, data structure definitions and
external data declarations for using the mreboot module.

*/

#ifndef _MREBOOT_
#define _MREBOOT_

/************************************************************************
                               INCLUDES

************************************************************************/
#include "mconst.h"


/************************************************************************
                                DEFINES

************************************************************************/
#define REBOOT_ENABLED          FALSE

/* Boot Constants */
#define COLD                    0
#define WARM                    1

/* Reboot Constants */
#define REBOOT_TIME             0               /* seconds from midnight */


/************************************************************************
                        STRUCTURE DEFINITIONS

The following structure definitions are included in mreboot.h, so that all
modules can have access to them.

************************************************************************/
typedef struct {
        double reboot_time;     /* reboot time in seconds from midnight */
        double current_time;    /* buffer_start_time in seconds from midnight */
        double previous_time;   /* previous current_time */
        int hour;
        int minute;
        int second;
} R_INFO;


/************************************************************************
                         EXTERNAL DECLARATIONS

These functions can be called from all modules that include this file.

************************************************************************/
PUBLIC FLAG r_check_time ();
PUBLIC FLAG r_get_reboot_status ();
PUBLIC char * r_get_reboot_time ();
PUBLIC void r_initialize_reboot ();
PUBLIC void r_set_reboot_time (int, int, int);
PUBLIC void r_set_reboot_status (FLAG);
PUBLIC void r_toggle_reboot_status ();

#endif
